/*
 * Decompiled with CFR 0.152.
 */
package lsatranslib;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class C12 {
    @Deprecated
    static void scrambleSimple(byte[] bytes) {
        boolean flip = bytes.length % 2 == 0;
        byte offset = (byte)bytes.length;
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)(bytes[i] * (flip ? 21 : 31) + offset);
            flip = !flip;
            ++i;
        }
    }

    static byte[] scrambleBytes(byte[] bytes) {
        byte[] result = new byte[bytes.length];
        boolean flip = bytes.length % 2 == 0;
        byte offset = (byte)bytes.length;
        int i = 0;
        while (i < bytes.length) {
            result[i] = (byte)(bytes[i] * (flip ? 21 : 31) + offset);
            flip = !flip;
            ++i;
        }
        return result;
    }

    @Deprecated
    static void unscrambleSimple(byte[] bytes) {
        boolean flip = bytes.length % 2 == 0;
        byte offset = (byte)bytes.length;
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)((bytes[i] - offset) * (flip ? 61 : 223));
            flip = !flip;
            ++i;
        }
    }

    static byte[] unscrambleBytes(byte[] bytes) {
        byte[] result = new byte[bytes.length];
        boolean flip = bytes.length % 2 == 0;
        byte offset = (byte)bytes.length;
        int i = 0;
        while (i < bytes.length) {
            result[i] = (byte)((bytes[i] - offset) * (flip ? 61 : 223));
            flip = !flip;
            ++i;
        }
        return result;
    }

    static byte[] scrambleLong(long value) {
        return C12.scrambleBytes(C12.toBytes(value));
    }

    static long unscrambleLong(byte[] bytes) {
        return C12.byteArrayToLong(C12.unscrambleBytes(bytes));
    }

    static byte[] toBytes(Serializable object) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteStream);
            out.writeObject(object);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            return new byte[0];
        }
        return byteStream.toByteArray();
    }

    static Object fromBytes(byte[] bytes) throws IOException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        ObjectInputStream inputStream = new ObjectInputStream(byteStream);
        try {
            return inputStream.readObject();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static <T> T fromBytes(byte[] bytes, T defaultObject) throws IOException {
        Object o = C12.fromBytes(bytes);
        if (defaultObject.getClass().isInstance(o)) {
            return (T)o;
        }
        return defaultObject;
    }

    static final byte[] toBytes(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    static final int byteArrayToInt(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }

    static final byte[] toBytes(long value) {
        return ByteBuffer.allocate(8).putLong(value).array();
    }

    static final long byteArrayToLong(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getLong();
    }

    static String asMACAdress(byte[] mac) {
        return C12.asMACAdress(mac, ':');
    }

    static String asMACAdress(byte[] mac, char divider) {
        StringBuilder sb = new StringBuilder(18);
        byte[] byArray = mac;
        int n = mac.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (sb.length() > 0) {
                sb.append(divider);
            }
            sb.append(String.format("%02x", b));
            ++n2;
        }
        return sb.toString();
    }

    static final String toJavaCode(byte[] bytes) {
        StringBuilder code = new StringBuilder(bytes.length * 7 + 1);
        code.append('{');
        int i = 0;
        while (i < bytes.length) {
            if (i % 10 == 0) {
                code.append('\n');
            }
            code.append(String.format("%4d, ", bytes[i]));
            ++i;
        }
        code.setLength(code.length() - 2);
        code.append("\n}");
        return code.toString();
    }

    static byte[] compressStrings(Collection<String> debugMessages) throws IOException {
        ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(outByteStream);
        for (String string : debugMessages) {
            gzip.write(string.getBytes("UTF-8"));
            gzip.write(10);
        }
        gzip.close();
        return outByteStream.toByteArray();
    }

    static ArrayList<String> decompressStrings(byte[] bytes) throws IOException {
        String line;
        ArrayList<String> debugMessages = new ArrayList<String>();
        ByteArrayInputStream inByteStream = new ByteArrayInputStream(bytes);
        GZIPInputStream gzip = new GZIPInputStream(inByteStream);
        InputStreamReader reader = new InputStreamReader((InputStream)gzip, "UTF-8");
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            debugMessages.add(line);
        }
        in.close();
        return debugMessages;
    }
}

