/*
 * Decompiled with CFR 0.152.
 */
package lsatranslib;

import java.util.Vector;
import lsatranslib.C1;
import lsatranslib.C8;

public class C5 {
    protected double m_E_LONG;
    protected double m_W_LONG;
    protected double m_S_LAT;
    protected double m_N_LAT;
    protected double m_LONG_INC;
    protected double m_LAT_INC;
    protected Vector<Double> m_vd_Lshift = new Vector();
    protected Vector<Double> m_vd_Bshift = new Vector();
    protected String m_cs_err;
    private String _cs_log = "";
    private double _zlon;
    private double _zlat;

    protected C5() {
        C1 gsa = new C1();
        this.m_cs_err = "";
        boolean b_seconds_ok = false;
        if (gsa.GS_TYPE.equals("SECONDS")) {
            b_seconds_ok = true;
        }
        this.m_S_LAT = this.getDouble(gsa.S_LAT);
        this.m_N_LAT = this.getDouble(gsa.N_LAT);
        this.m_E_LONG = this.getDouble(gsa.E_LONG);
        this.m_W_LONG = this.getDouble(gsa.W_LONG);
        this.m_LAT_INC = this.getDouble(gsa.LAT_INC);
        this.m_LONG_INC = this.getDouble(gsa.LONG_INC);
        for (String str : gsa.GS_COUNT) {
            byte[] ba1 = str.getBytes();
            byte[] ba = C8.f1(ba1);
            String str2 = C5.toStr(ba);
            double d1 = this.getDouble(this.Left(str2, 10));
            double d2 = this.getDouble(this.Mid(str2, 10, 10));
            this.m_vd_Bshift.add(d1);
            this.m_vd_Lshift.add(d2);
        }
        if (!b_seconds_ok) {
            this.m_cs_err = "Datei mit Shiftwerten muss Einheit GS_TYPE SECONDS haben.";
        }
    }

    protected static String toStr(byte[] ba) {
        String str2 = new String(C5.str(ba));
        return str2;
    }

    protected boolean func2(double qlon, double qlat) {
        qlon = -qlon * 3600.0;
        qlat *= 3600.0;
        if (this.m_E_LONG <= qlon && qlon <= this.m_W_LONG && this.m_S_LAT <= qlat && qlat <= this.m_N_LAT) {
            String cs;
            double fcol = (qlon - this.m_E_LONG) / this.m_LONG_INC;
            double frow = (qlat - this.m_S_LAT) / this.m_LAT_INC;
            double col = Math.floor(fcol);
            double row = Math.floor(frow);
            double ppr = Math.floor((this.m_W_LONG - this.m_E_LONG) / this.m_LONG_INC + 0.5) + 1.0;
            int icol = (int)col;
            int irow = (int)row;
            int ippr = (int)ppr;
            int se = irow * ippr + icol;
            int sw = se + 1;
            int ne = se + ippr;
            int nw = ne + 1;
            double dx = fcol - Math.floor(fcol);
            double dy = frow - Math.floor(frow);
            double sv = (1.0 - dx) * (1.0 - dy) * this.m_vd_Lshift.get(se) + dx * (1.0 - dy) * this.m_vd_Lshift.get(sw) + (1.0 - dx) * dy * this.m_vd_Lshift.get(ne) + dx * dy * this.m_vd_Lshift.get(nw);
            double zlon = qlon + sv;
            double svb = (1.0 - dx) * (1.0 - dy) * this.m_vd_Bshift.get(se) + dx * (1.0 - dy) * this.m_vd_Bshift.get(sw) + (1.0 - dx) * dy * this.m_vd_Bshift.get(ne) + dx * dy * this.m_vd_Bshift.get(nw);
            double zlat = qlat + svb;
            this._zlon = -zlon / 3600.0;
            this._zlat = zlat / 3600.0;
            this._cs_log = cs = String.format("Gesamt L %.3f SE(%d) %.3f SW(%d) %.3f NE(%d) %.3f NW(%d) %.3f   Gesamt B %.3f SE(%d) %.3f SW(%d) %.3f NE(%d) %.3f NW(%d) %.3f", sv, se, this.m_vd_Lshift.get(se), sw, this.m_vd_Lshift.get(sw), ne, this.m_vd_Lshift.get(ne), nw, this.m_vd_Lshift.get(nw), svb, se, this.m_vd_Bshift.get(se), sw, this.m_vd_Bshift.get(sw), ne, this.m_vd_Bshift.get(ne), nw, this.m_vd_Bshift.get(nw));
            return true;
        }
        return false;
    }

    protected boolean func1(double zlon, double zlat) {
        zlon = -zlon * 3600.0;
        double qlon = zlon;
        double qlat = zlat *= 3600.0;
        if (this.m_E_LONG <= qlon && qlon <= this.m_W_LONG && this.m_S_LAT <= qlat && qlat <= this.m_N_LAT) {
            int i = 0;
            while (i < 4) {
                double fcol = (qlon - this.m_E_LONG) / this.m_LONG_INC;
                double frow = (qlat - this.m_S_LAT) / this.m_LAT_INC;
                double col = Math.floor(fcol);
                double row = Math.floor(frow);
                double ppr = Math.floor((this.m_W_LONG - this.m_E_LONG) / this.m_LONG_INC + 0.5) + 1.0;
                int icol = (int)col;
                int irow = (int)row;
                int ippr = (int)ppr;
                int se = irow * ippr + icol;
                int sw = se + 1;
                int ne = se + ippr;
                int nw = ne + 1;
                double dx = fcol - Math.floor(fcol);
                double dy = frow - Math.floor(frow);
                double slon = (1.0 - dx) * (1.0 - dy) * this.m_vd_Lshift.get(se) + dx * (1.0 - dy) * this.m_vd_Lshift.get(sw) + (1.0 - dx) * dy * this.m_vd_Lshift.get(ne) + dx * dy * this.m_vd_Lshift.get(nw);
                double slat = (1.0 - dx) * (1.0 - dy) * this.m_vd_Bshift.get(se) + dx * (1.0 - dy) * this.m_vd_Bshift.get(sw) + (1.0 - dx) * dy * this.m_vd_Bshift.get(ne) + dx * dy * this.m_vd_Bshift.get(nw);
                qlon = zlon - slon;
                qlat = zlat - slat;
                ++i;
            }
            qlon = -qlon / 3600.0;
            this._zlon = qlon;
            this._zlat = qlat /= 3600.0;
            return true;
        }
        return false;
    }

    protected Vector<Double> getOutWerte() {
        Vector<Double> vec = new Vector<Double>();
        vec.add(this._zlon);
        vec.add(this._zlat);
        return vec;
    }

    protected String getLog() {
        return this._cs_log;
    }

    protected boolean IsValid() {
        return "" == this.m_cs_err;
    }

    protected String getErrMsg() {
        return this.m_cs_err;
    }

    private double getDouble(String cs) {
        int i = this.Find(cs, ".");
        if (i == -1) {
            i = this.Find(cs, ",");
        }
        if (i == -1) {
            return Double.valueOf(cs);
        }
        double d = Double.valueOf(this.Left(cs, i));
        String cs_n = this.Right(cs, cs.length() - (i + 1));
        cs_n = cs_n.trim();
        double n = Double.valueOf(cs_n);
        double t = 1.0;
        int j = 0;
        while (j < cs_n.length()) {
            t *= 10.0;
            ++j;
        }
        d = d < 0.0 ? (d -= n / t) : (d += n / t);
        return d;
    }

    private static byte[] str(byte[] ba) {
        int h = ba.length - 1;
        while (h > 0) {
            int n = h - 1;
            ba[n] = (byte)(ba[n] - ba[h]);
            --h;
        }
        return ba;
    }

    private String Left(String s, int i) {
        if (s.length() >= i) {
            s = s.substring(0, i);
        }
        return s;
    }

    private String Right(String s, int i) {
        if (s.length() >= i) {
            s = s.substring(s.length() - i, s.length());
        }
        return s;
    }

    private String Mid(String s, int i, int j) {
        if (s.length() >= i + j) {
            s = s.substring(i, i + j);
        }
        return s;
    }

    private int Find(String s, String value) {
        return s.indexOf(value);
    }
}

