/*
 * Decompiled with CFR 0.152.
 */
package lsatranslib;

import java.util.Arrays;
import lsatranslib.C10;
import lsatranslib.C11;
import lsatranslib.C16;
import lsatranslib.C18;
import lsatranslib.C19;

public abstract class C9
implements C11,
C10 {
    static final int EOF = -1;
    protected static final int MIME_CHUNK_SIZE = 76;
    protected static final int PEM_CHUNK_SIZE = 64;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    protected final byte PAD = (byte)61;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;

    protected C9(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength) {
        this.unencodedBlockSize = unencodedBlockSize;
        this.encodedBlockSize = encodedBlockSize;
        boolean useChunking = lineLength > 0 && chunkSeparatorLength > 0;
        this.lineLength = useChunking ? lineLength / encodedBlockSize * encodedBlockSize : 0;
        this.chunkSeparatorLength = chunkSeparatorLength;
    }

    boolean hasData(Context context) {
        return context.buffer != null;
    }

    int available(Context context) {
        return context.buffer != null ? context.pos - context.readPos : 0;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    private byte[] resizeBuffer(Context context) {
        if (context.buffer == null) {
            context.buffer = new byte[this.getDefaultBufferSize()];
            context.pos = 0;
            context.readPos = 0;
        } else {
            byte[] b = new byte[context.buffer.length * 2];
            System.arraycopy(context.buffer, 0, b, 0, context.buffer.length);
            context.buffer = b;
        }
        return context.buffer;
    }

    protected byte[] ensureBufferSize(int size, Context context) {
        if (context.buffer == null || context.buffer.length < context.pos + size) {
            return this.resizeBuffer(context);
        }
        return context.buffer;
    }

    int readResults(byte[] b, int bPos, int bAvail, Context context) {
        if (context.buffer != null) {
            int len = Math.min(this.available(context), bAvail);
            System.arraycopy(context.buffer, context.readPos, b, bPos, len);
            context.readPos += len;
            if (context.readPos >= context.pos) {
                context.buffer = null;
            }
            return len;
        }
        return context.eof ? -1 : 0;
    }

    protected static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object id(Object obj) throws C18 {
        if (!(obj instanceof byte[])) {
            throw new C18("Parameter supplied to Base-N encode is not a byte[]");
        }
        return this.ib((byte[])obj);
    }

    protected String encodeToString(byte[] pArray) {
        return C19.newStringUtf8(this.ib(pArray));
    }

    protected String encodeAsString(byte[] pArray) {
        return C19.newStringUtf8(this.ib(pArray));
    }

    @Override
    public Object ic(Object obj) throws C16 {
        if (obj instanceof byte[]) {
            return this.ia((byte[])obj);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new C16("Parameter supplied to Base-N decode is not a byte[] or a String");
    }

    protected byte[] decode(String pArray) {
        return this.ia(C19.getBytesUtf8(pArray));
    }

    @Override
    public byte[] ia(byte[] pArray) {
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        Context context = new Context();
        this.func2(pArray, 0, pArray.length, context);
        this.func2(pArray, 0, -1, context);
        byte[] result = new byte[context.pos];
        this.readResults(result, 0, result.length, context);
        return result;
    }

    @Override
    public byte[] ib(byte[] pArray) {
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        Context context = new Context();
        this.func1(pArray, 0, pArray.length, context);
        this.func1(pArray, 0, -1, context);
        byte[] buf = new byte[context.pos - context.readPos];
        this.readResults(buf, 0, buf.length, context);
        return buf;
    }

    abstract void func1(byte[] var1, int var2, int var3, Context var4);

    abstract void func2(byte[] var1, int var2, int var3, Context var4);

    protected abstract boolean isInAlphabet(byte var1);

    protected boolean isInAlphabet(byte[] arrayOctet, boolean allowWSPad) {
        int i = 0;
        while (i < arrayOctet.length) {
            if (!(this.isInAlphabet(arrayOctet[i]) || allowWSPad && (arrayOctet[i] == 61 || C9.isWhiteSpace(arrayOctet[i])))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isInAlphabet(String basen) {
        return this.isInAlphabet(C19.getBytesUtf8(basen), true);
    }

    protected boolean containsAlphabetOrPad(byte[] arrayOctet) {
        if (arrayOctet == null) {
            return false;
        }
        byte[] byArray = arrayOctet;
        int n = arrayOctet.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            if (61 == element || this.isInAlphabet(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected long getEncodedLength(byte[] pArray) {
        long len = (long)((pArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            len += (len + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return len;
    }

    static class Context {
        int ibitWorkArea;
        long lbitWorkArea;
        byte[] buffer;
        int pos;
        int readPos;
        boolean eof;
        int currentLinePos;
        int modulus;

        Context() {
        }

        public String toString() {
            return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, lbitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), Arrays.toString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.lbitWorkArea, this.modulus, this.pos, this.readPos);
        }
    }
}

