/*
 * Decompiled with CFR 0.152.
 */
package lsatranslib.zTree;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.TreeSet;
import java.util.Vector;
import lsatranslib.zTree.zBox;
import lsatranslib.zTree.zGeoObj;
import lsatranslib.zTree.zGeoObjChain;
import lsatranslib.zTree.zGridDynPool;
import lsatranslib.zTree.zMeanManager;

public class zGridDynPoolManager {
    Vector<DataOutputStream> fdump = new Vector();
    zMeanManager mman = new zMeanManager();
    String sfileprefix;
    zGridDynPool root = null;
    double w;
    double h;
    double w_;
    double h_;
    double maxnx;
    double maxny;
    zGeoObjChain largeobjs;

    public zGridDynPoolManager(double W, double H, double MaxNX, double MaxNY) {
        this.w = W * MaxNX;
        this.h = H * MaxNY;
        this.w_ = W;
        this.h_ = H;
        this.maxnx = MaxNX;
        this.maxny = MaxNY;
        this.largeobjs = null;
    }

    public void AddGeoObj(long oid, String sm, double l, double b, double r, double t) {
        this.AddGeoObj(oid, this.mman.GetNr(sm), l, b, r, t);
    }

    void AddGeoObj(long oid, int im, double l, double b, double r, double t) {
        double ngrids = ((r - l) / this.w_ + 1.0) * ((t - b) / this.h_ + 1.0);
        if (ngrids > 50.0) {
            zGeoObj newo = new zGeoObj(l, b, r, t, im, oid);
            zGeoObjChain newc = new zGeoObjChain(newo);
            if (this.largeobjs == null) {
                this.largeobjs = newc;
            } else {
                newc.next = this.largeobjs;
                this.largeobjs = newc;
            }
        } else {
            double tmp;
            double _l = (double)((int)(l / this.w)) * this.w;
            double _b = (double)((int)(b / this.h)) * this.h;
            double _r = (double)((int)(r / this.w + 0.5)) * this.w + this.w;
            double _t = (double)((int)(t / this.h + 0.5)) * this.h + this.h;
            if (_l > _r) {
                tmp = _l;
                _l = _r;
                _r = tmp;
            }
            if (_b > _t) {
                tmp = _b;
                _b = _t;
                _t = tmp;
            }
            double x = _l;
            while (x < _r) {
                double y = _b;
                while (y < _t) {
                    zBox box = new zBox(x, y, x + this.w, y + this.h);
                    boolean bfound = false;
                    zGridDynPool p = this.root;
                    while (p != null && !bfound) {
                        if (p.box.equals(box)) {
                            bfound = true;
                            p.grid.AddGeoObj(oid, im, l > box.left ? l : box.left, b > box.bottom ? b : box.bottom, r < box.right ? r : box.right, t < box.top ? t : box.top);
                        }
                        p = p.next;
                    }
                    if (!bfound) {
                        zGridDynPool pnew = new zGridDynPool(this.w / this.maxnx, this.h / this.maxny, box, this.mman);
                        pnew.grid.AddGeoObj(oid, im, l > box.left ? l : box.left, b > box.bottom ? b : box.bottom, r < box.right ? r : box.right, t < box.top ? t : box.top);
                        if (this.root == null) {
                            this.root = pnew;
                        } else {
                            pnew.next = this.root;
                            this.root = pnew;
                        }
                    }
                    y += this.h;
                }
                x += this.w;
            }
        }
        if (this.fdump.size() > 0) {
            try {
                this.fdump.lastElement().writeLong(oid);
                this.fdump.lastElement().writeInt(im);
                this.fdump.lastElement().writeDouble(l);
                this.fdump.lastElement().writeDouble(b);
                this.fdump.lastElement().writeDouble(r);
                this.fdump.lastElement().writeDouble(t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean DelGeoObj(long oid, String sm, double l, double b, double r, double t) {
        return this.DelGeoObj(oid, this.mman.GetNr(sm), l, b, r, t);
    }

    boolean DelGeoObj(long oid, int im, double l, double b, double r, double t) {
        boolean bdel = false;
        double ngrids = ((r - l) / this.w_ + 1.0) * ((t - b) / this.h_ + 1.0);
        if (ngrids > 50.0) {
            zGeoObjChain prev = null;
            zGeoObjChain p = this.largeobjs;
            while (p != null && !bdel) {
                if (p.geoobj.oid == oid) {
                    if (prev != null) {
                        prev.next = p.next;
                    } else {
                        this.largeobjs = p.next;
                    }
                    bdel = true;
                    break;
                }
                prev = p;
                p = p.next;
            }
        } else {
            double _l = (double)((int)(l / this.w)) * this.w;
            double _b = (double)((int)(b / this.h)) * this.h;
            double _r = (double)((int)(r / this.w + 0.5)) * this.w + this.w;
            double _t = (double)((int)(t / this.h + 0.5)) * this.h + this.h;
            double x = _l;
            while (x < _r) {
                double y = _b;
                while (y < _t) {
                    zBox box = new zBox(x, y, x + this.w, y + this.h);
                    zGridDynPool p = this.root;
                    while (p != null) {
                        if (p.box.equals(box) && p.grid.DelGeoObj(oid, im, l > box.left ? l : box.left, b > box.bottom ? b : box.bottom, r < box.right ? r : box.right, t < box.top ? t : box.top)) {
                            bdel = true;
                        }
                        p = p.next;
                    }
                    y += this.h;
                }
                x += this.w;
            }
        }
        if (this.fdump.size() > 0) {
            if ((im *= -1) > 0) {
                im *= -1;
            }
            try {
                this.fdump.lastElement().writeLong(oid);
                this.fdump.lastElement().writeInt(im);
                this.fdump.lastElement().writeDouble(l);
                this.fdump.lastElement().writeDouble(b);
                this.fdump.lastElement().writeDouble(r);
                this.fdump.lastElement().writeDouble(t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bdel;
    }

    public void GetGeoObj(TreeSet<Long> re, Vector<String> lsm, double l, double b, double r, double t) {
        if (lsm != null) {
            TreeSet<Integer> vmi = new TreeSet<Integer>();
            for (String pm : lsm) {
                vmi.add(this.mman.GetNr(pm));
            }
            this.GetGeoObj_(re, vmi, l, b, r, t);
        } else {
            this.GetGeoObj_(re, null, l, b, r, t);
        }
    }

    void GetGeoObj_(TreeSet<Long> re, TreeSet<Integer> vmi, double l, double b, double r, double t) {
        zBox box = new zBox(l, b, r, t);
        zGridDynPool p = this.root;
        while (p != null) {
            if (p.box.IntersectsWith(box)) {
                p.grid.GetGeoObj(re, vmi, box);
            }
            p = p.next;
        }
        zGeoObjChain plarge = this.largeobjs;
        while (plarge != null) {
            if (box.IntersectsWith(plarge.geoobj.box) && (vmi == null || vmi.contains(plarge.geoobj.mi))) {
                re.add(plarge.geoobj.oid);
            }
            plarge = plarge.next;
        }
    }

    boolean openFileDump(String sfile) {
        File file;
        block8: {
            this.sfileprefix = sfile;
            long count = 0L;
            this.mman.openFileDump(sfile);
            String sfilemain = String.valueOf(this.sfileprefix) + ".z.trd";
            file = new File(sfilemain);
            if (!file.exists()) break block8;
            FileInputStream fi = new FileInputStream(file);
            DataInputStream di = new DataInputStream(fi);
            try {
                while (true) {
                    long oid = di.readLong();
                    int im = di.readInt();
                    double l = di.readDouble();
                    double b = di.readDouble();
                    double r = di.readDouble();
                    double t = di.readDouble();
                    if (im >= 0) {
                        ++count;
                        this.AddGeoObj(oid, im, l, b, r, t);
                        continue;
                    }
                    this.DelGeoObj(oid, -1 * im, l, b, r, t);
                }
            }
            catch (EOFException eOFException) {
                di.close();
                return true;
            }
        }
        try {
            if (file.createNewFile()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    boolean beginTransaction() {
        try {
            this.mman.flushFileDump();
            if (this.fdump.size() > 0) {
                this.fdump.lastElement().flush();
            }
            String sfiletx = String.format(String.valueOf(this.sfileprefix) + ".z.%d.txin", this.fdump.size());
            FileOutputStream fout = new FileOutputStream(new File(sfiletx));
            DataOutputStream dout = new DataOutputStream(fout);
            this.fdump.add(dout);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean abortTransaction() {
        try {
            this.mman.flushFileDump();
            if (this.fdump.size() > 0) {
                this.fdump.lastElement().close();
                String sfiletx = String.format(String.valueOf(this.sfileprefix) + ".z.%d.txin", this.fdump.size());
                FileInputStream fi = new FileInputStream(new File(sfiletx));
                DataInputStream fread = new DataInputStream(fi);
                try {
                    while (true) {
                        long oid = fread.readLong();
                        int im = fread.readInt();
                        double l = fread.readDouble();
                        double b = fread.readDouble();
                        double r = fread.readDouble();
                        double t = fread.readDouble();
                        if (im >= 0) {
                            this.DelGeoObj(oid, im, l, b, r, t);
                            continue;
                        }
                        this.AddGeoObj(oid, -1 * im, l, b, r, t);
                    }
                }
                catch (EOFException eOFException) {
                    this.fdump.setSize(this.fdump.size() - 1);
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    boolean commitTransaction() {
        try {
            this.mman.flushFileDump();
            if (this.fdump.size() > 0) {
                this.fdump.lastElement().close();
                String sfiletx = String.format(String.valueOf(this.sfileprefix) + ".z.%d.txin", this.fdump.size());
                File file = new File(sfiletx);
                if (file.exists()) {
                    FileInputStream fi = new FileInputStream(file);
                    DataInputStream di = new DataInputStream(fi);
                    this.fdump.lastElement().close();
                    this.fdump.setSize(this.fdump.size() - 1);
                    if (this.fdump.size() == 0) {
                        String sfilesave = String.valueOf(this.sfileprefix) + ".z.trd";
                        FileOutputStream fout = new FileOutputStream(new File(sfilesave), true);
                        DataOutputStream dout = new DataOutputStream(fout);
                        this.Copy(di, dout);
                        di.close();
                        dout.close();
                    } else {
                        this.fdump.lastElement().close();
                        String sfilesave = String.format(String.valueOf(this.sfileprefix) + ".z.%d.txin", this.fdump.size());
                        FileOutputStream fout = new FileOutputStream(new File(sfilesave), true);
                        DataOutputStream dout = new DataOutputStream(fout);
                        this.Copy(di, dout);
                        di.close();
                        dout.close();
                        DataOutputStream dotx = new DataOutputStream(fout);
                        this.fdump.set(this.fdump.size() - 1, dotx);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    void Copy(DataInputStream fread, DataOutputStream fsave) {
        try {
            try {
                while (true) {
                    long oid = fread.readLong();
                    int im = fread.readInt();
                    double l = fread.readDouble();
                    double b = fread.readDouble();
                    double r = fread.readDouble();
                    double t = fread.readDouble();
                    if (oid == 0L) continue;
                    fsave.writeLong(oid);
                    fsave.writeInt(im);
                    fsave.writeDouble(l);
                    fsave.writeDouble(b);
                    fsave.writeDouble(r);
                    fsave.writeDouble(t);
                }
            }
            catch (EOFException eOFException) {
                fsave.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    long GetCount() {
        long re = 0L;
        zGridDynPool p = this.root;
        while (p != null) {
            re += p.grid.GetCount();
            p = p.next;
        }
        return re;
    }
}

