/*
 * Decompiled with CFR 0.152.
 */
package lsatranslib.zTree;

import java.util.TreeSet;
import lsatranslib.zTree.zBox;
import lsatranslib.zTree.zGeoObj;
import lsatranslib.zTree.zGeoObjChain;
import lsatranslib.zTree.zMeanManager;

public class zGridRootDyn {
    long nreorg;
    double nx = -1.0;
    double ny = -1.0;
    double l;
    double b;
    double r;
    double t;
    zGeoObjChain[][] grid = null;
    zMeanManager mman;
    double w;
    double h;

    public zGridRootDyn(double W, double H, zMeanManager mMan) {
        this.w = W;
        this.h = H;
        this.nreorg = 0L;
        this.mman = mMan;
    }

    void ReOrginize(double nl, double nb, double nr, double nt) {
        double tmp;
        ++this.nreorg;
        double _l = (double)((long)(nl / this.w)) * this.w;
        double _b = (double)((long)(nb / this.h)) * this.h;
        double _r = (double)((long)(nr / this.w + 0.5)) * this.w + this.w;
        double _t = (double)((long)(nt / this.h + 0.5)) * this.h + this.h;
        if (_l > _r) {
            tmp = _l;
            _l = _r;
            _r = tmp;
        }
        if (_b > _t) {
            tmp = _b;
            _b = _t;
            _t = tmp;
        }
        double _nx = (long)((_r - _l) / this.w + 0.5);
        double _ny = (long)((_t - _b) / this.h + 0.5);
        if (_nx <= 0.0) {
            _nx = 1.0;
        }
        if (_ny <= 0.0) {
            _ny = 1.0;
        }
        zGeoObjChain[][] _grid = new zGeoObjChain[(int)_nx][(int)_ny];
        int i = 0;
        while ((double)i < _nx) {
            int j = 0;
            while ((double)j < _ny) {
                _grid[i][j] = null;
                ++j;
            }
            ++i;
        }
        if (this.grid != null) {
            int dx = (int)((this.l - _l) / this.w + 0.5);
            int dy = (int)((this.b - _b) / this.h + 0.5);
            int i2 = 0;
            while ((double)i2 < this.nx) {
                int j = 0;
                while ((double)j < this.ny) {
                    if (this.grid[i2][j] != null) {
                        _grid[i2 + dx][j + dy] = this.grid[i2][j];
                    }
                    ++j;
                }
                ++i2;
            }
        }
        this.l = _l;
        this.b = _b;
        this.r = _r;
        this.t = _t;
        this.nx = _nx;
        this.ny = _ny;
        this.grid = _grid;
    }

    public void AddGeoObj(long oid, String sm, double l, double b, double r, double t) {
        int mi = this.mman.GetNr(sm);
        this.AddGeoObj(oid, mi, l, b, r, t);
    }

    public void AddGeoObj(long oid, int mi, double l, double b, double r, double t) {
        if (this.grid == null) {
            this.ReOrginize(l, b, r, t);
        } else if (this.l > l || this.b > b || this.r < r || this.t < t) {
            this.ReOrginize(this.l < l ? this.l : l, this.b < b ? this.b : b, this.r > r ? this.r : r, this.t > t ? this.t : t);
        }
        zGeoObj newo = new zGeoObj(l, b, r, t, mi, oid);
        int minx = (int)((l - this.l) / this.w);
        int miny = (int)((b - this.b) / this.h);
        int maxx = (int)((r - this.l) / this.w + 0.5);
        int maxy = (int)((t - this.b) / this.h + 0.5);
        if (minx < 0) {
            minx = 0;
        }
        if (miny < 0) {
            miny = 0;
        }
        if ((double)maxx >= this.nx) {
            maxx = (int)(this.nx - 1.0);
        }
        if ((double)maxy >= this.ny) {
            maxy = (int)(this.ny - 1.0);
        }
        int i = minx;
        while (i <= maxx) {
            int j = miny;
            while (j <= maxy) {
                zGeoObjChain newc = new zGeoObjChain(newo);
                zGeoObjChain p = this.grid[i][j];
                if (p == null) {
                    this.grid[i][j] = newc;
                } else {
                    newc.next = p;
                    this.grid[i][j] = newc;
                }
                ++j;
            }
            ++i;
        }
    }

    public long GetCount() {
        TreeSet<Long> objs = new TreeSet<Long>();
        int i = 0;
        while ((double)i < this.nx) {
            int j = 0;
            while ((double)j < this.ny) {
                zGeoObjChain p = this.grid[i][j];
                while (p != null) {
                    objs.add(p.geoobj.oid);
                    p = p.next;
                }
                ++j;
            }
            ++i;
        }
        return objs.size();
    }

    public void GetGeoObj(TreeSet<Long> re, TreeSet<Integer> vmi, zBox box) {
        if (!box.IntersectsWith(this.l, this.b, this.r, this.t)) {
            return;
        }
        int minx = (int)((box.left - this.l) / this.w);
        int miny = (int)((box.bottom - this.b) / this.h);
        int maxx = (int)((box.right - this.l) / this.w + 0.5);
        int maxy = (int)((box.top - this.b) / this.h + 0.5);
        if (minx < 0) {
            minx = 0;
        }
        if (miny < 0) {
            miny = 0;
        }
        if ((double)maxx >= this.nx) {
            maxx = (int)(this.nx - 1.0);
        }
        if ((double)maxy >= this.ny) {
            maxy = (int)(this.ny - 1.0);
        }
        int i = minx;
        while (i <= maxx) {
            int j = miny;
            while (j <= maxy) {
                zGeoObjChain p = this.grid[i][j];
                while (p != null) {
                    if (box.IntersectsWith(p.geoobj.box) && (vmi == null || vmi.contains(p.geoobj.mi))) {
                        re.add(p.geoobj.oid);
                    }
                    p = p.next;
                }
                ++j;
            }
            ++i;
        }
    }

    boolean DelGeoObj(long oid, String sm, double l, double b, double r, double t) {
        return this.DelGeoObj(oid, this.mman.GetNr(sm), l, b, r, t);
    }

    public boolean DelGeoObj(long oid, int im, double l, double b, double r, double t) {
        int minx = (int)((l - this.l) / this.w);
        int miny = (int)((b - this.b) / this.h);
        int maxx = (int)((r - this.l) / this.w + 0.5);
        int maxy = (int)((t - this.b) / this.h + 0.5);
        if (minx < 0) {
            minx = 0;
        }
        if (miny < 0) {
            miny = 0;
        }
        if ((double)maxx >= this.nx) {
            maxx = (int)(this.nx - 1.0);
        }
        if ((double)maxy >= this.ny) {
            maxy = (int)(this.ny - 1.0);
        }
        zGeoObj delobj = null;
        int i = minx;
        while (i <= maxx) {
            int j = miny;
            while (j <= maxy) {
                zGeoObjChain prev = null;
                zGeoObjChain p = this.grid[i][j];
                while (p != null) {
                    if (p.geoobj.oid == oid) {
                        if (prev != null) {
                            prev.next = p.next;
                        } else {
                            this.grid[i][j] = p.next;
                        }
                        delobj = p.geoobj;
                        break;
                    }
                    prev = p;
                    p = p.next;
                }
                ++j;
            }
            ++i;
        }
        return delobj != null;
    }
}

